﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class SSNAndFacilitySelect2 : System.Web.UI.UserControl
{
    private readonly UserAccountManager _currentUser = (UserAccountManager)HttpContext.Current.User;

    /// <summary>
    /// return selected SSN
    /// </summary>
    private string _snum;
    public string Snum
    {
        get
        {
            string snum = TxtBoxSnum.Text.Trim();
            return snum;

            //string ssnOut = String.Empty;
            //if (!String.IsNullOrEmpty(ssn) && ssn.Length == 10)
            //{
            //    ssnOut = string.Format("{0}-{1}-{2}", ssn.Substring(0, 3), ssn.Substring(3, 2), ssn.Substring(5, 4));
            //}
            //return ssnOut;
        }
        set
        {
            _snum = value;
            TxtBoxSnum.Text = _snum;
        }
}
    /// <summary>
    /// return selected VISN value
    /// </summary>
    public string VISN
    {
        get
        {
            return DropDownListVisnID.SelectedValue.Trim();
        }
    }
    /// <summary>
    /// return selected Facility
    /// </summary>
    public string FacilityStationNumber
    {
        get { return this.DropDownListFacility.SelectedValue.Trim(); }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            EnableDropDownListsVisnAndStation(true, false);
        }
    }
    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListVisnID.SelectedIndex > 0)
        {
            SetDropDownListFacility();
            EnableDropDownListsVisnAndStation(true, true);
        }
        else
        {
            EnableDropDownListsVisnAndStation(true, false);
        }
    }

    private void SetDropDownListVisnId()
    {
        if (!_currentUser.IsInRole(16))
        {
            DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
        
        DropDownListVisnID.SelectedIndex = 0;
        EnableDropDownListsVisnAndStation(true, false);
    }
    private void SetDropDownListFacility()
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            if (_currentUser.IsInRole(16))
            {
                DropDownListFacility.DataSource = SqlDataSource1;
            }
            else
            {
                DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
            }
            DropDownListFacility.DataBind();
            DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));
            DropDownListFacility.SelectedIndex = 0;
        }
    }
    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        //DivVisn.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        LabelStation.Visible = dropDownListFacilityIsVisible;
        //DivStation.Visible = dropDownListFacilityIsVisible;
    }
}
